/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.debug;

public class AddressStatistics {
    private int execution_counter;
    private int cycle_counter;
    private int address;

    public AddressStatistics(int address) {
        this.address = address;
        this.reset();
    }

    public void reset() {
        this.execution_counter = 0;
        this.cycle_counter = 0;
    }

    void countExecution(int cycles) {
        ++this.execution_counter;
        this.cycle_counter += cycles;
    }

    public int getAddress() {
        return this.address;
    }

    public int getExecutionCounter() {
        return this.execution_counter;
    }

    public int getCycleCounter() {
        return this.cycle_counter;
    }

    public String getToolTip() {
        return "Count: " + this.execution_counter + "  Cycles: " + this.cycle_counter + "  Avg. Cycles: " + (this.execution_counter > 0 ? this.cycle_counter / this.execution_counter : 0);
    }
}

